//Listing 13.16. Przykad rozszerzonej hierarchii dziedziczenia dla klas Account
#include <iostream>
using namespace std;

class Account { // klasa bazowa
protected:
  double balance;
public:
  Account(double initBalance = 0)
  { balance = initBalance; }
  double getBal() // odziedziczone bez zmian
  { return balance; }
  void withdraw(double amount) // zdefiniowana ponownie w klasie pochodnej
  { if (balance > amount)
      balance -= amount; }
  void deposit(double amount) // odziedziczone bez zmian
  { balance += amount; }
  } ; // brak zmian istniejcej klasy

class CheckingAccount : public Account { // klasa pochodna
protected:
  double fee;
public:
  CheckingAccount(double initBalance = 0)
  { balance = initBalance; fee = 0.2; }
  void withdraw(double amount) // ukrywa metod klasy bazowej
  { if (balance > amount)
      balance = balance - amount - fee; }
  } ; // brak zmian istniejcej klasy

class InternationalAccount : public CheckingAccount { // wspaniale!
public:
  InternationalAccount(double initBalance)
  { balance = initBalance; }
  void deposit(double amount, double fee) // ukrywa metod klasy bazowej
  { balance = balance + amount - fee - CheckingAccount::fee; }
  } ; // zadanie jest przekazywane do nowej klasy

int main()
{
  CheckingAccount a1(1000); // obiekt klasy pochodnej
  a1.withdraw(100); // metoda klasy pochodnej
  a1.deposit(200); // metoda klasy bazowej
  InternationalAccount a2(1000); // nowy obiekt serwera
  a2.deposit(200,5); // metoda klasy pochodnej
  cout << " Kocowe stany kont \n";
  cout << " pierwsze sprawdzanie obiektu konta: "
       << a1.getBal() << endl;
  cout << " drugie sprawdzanie obiektu konta: "
       << a2.getBal() << endl;
  return 0;
}
